/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.IgnoreError;
import com.kenai.jaffl.annotations.SaveError;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvokerUtil {
    InvokerUtil() {
    }

    static final Type getNativeReturnType(Method method) {
        return InvokerUtil.getNativeReturnType(method.getReturnType());
    }

    static final Type getNativeReturnType(Class clazz) {
        if (Void.class.isAssignableFrom(clazz) || Void.TYPE == clazz) {
            return Type.VOID;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return Type.DOUBLE;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (Address.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported return type: " + clazz);
    }

    static final Type getNativeParameterType(Class clazz) {
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return Type.DOUBLE;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return Type.SINT32;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (Address.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (Buffer.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (ByReference.class.isAssignableFrom(clazz)) {
            return Type.POINTER;
        }
        if (clazz.isArray()) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + clazz);
    }

    public static final boolean requiresErrno(Method method) {
        boolean bl = true;
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof IgnoreError) {
                bl = false;
                continue;
            }
            if (!(annotation instanceof SaveError)) continue;
            bl = true;
        }
        return bl;
    }

    public static final com.kenai.jffi.CallingConvention getCallingConvention(Map<LibraryOption, ?> map) {
        CallingConvention callingConvention = (CallingConvention)((Object)map.get((Object)LibraryOption.CallingConvention));
        if (callingConvention instanceof com.kenai.jffi.CallingConvention) {
            return (com.kenai.jffi.CallingConvention)((Object)callingConvention);
        }
        if (callingConvention instanceof CallingConvention) {
            switch (callingConvention) {
                case DEFAULT: {
                    return com.kenai.jffi.CallingConvention.DEFAULT;
                }
                case STDCALL: {
                    return com.kenai.jffi.CallingConvention.STDCALL;
                }
            }
        } else if (callingConvention != null) {
            throw new IllegalArgumentException("unknown calling convention: " + (Object)((Object)callingConvention));
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }
}

